<?php
header("Content-Type: application/json");
ini_set('display_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: GET');

require 'my_family_db.php';

if (!isset($_GET['family_id'])) {
    http_response_code(400);
    echo json_encode([
        "status" => "error",
        "message" => "Parameter family_id tidak ditemukan"
    ]);
    exit;
}

$family_id = intval($_GET['family_id']);

try {
    $stmt = $conn->prepare("SELECT * FROM family_members WHERE family_id = :family_id");
    $stmt->bindParam(':family_id', $family_id, PDO::PARAM_INT);
    $stmt->execute();

    $members = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "status" => "success",
        "data" => $members
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "status" => "error",
        "message" => "Database error: " . $e->getMessage()
    ]);
}