<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once 'my_family_db.php';

$id = $_POST['id'] ?? '';
$name = $_POST['name'] ?? '';
$father_photo = $_FILES['father_photo'] ?? null;
$mother_photo = $_FILES['mother_photo'] ?? null;

if (!$id || !$name) {
    echo json_encode(['status' => 'error', 'message' => 'Data tidak lengkap.']);
    exit;
}

try {
    // Handle upload foto jika ada
    $fieldsToUpdate = ['name = :name'];
    $params = [':name' => $name, ':id' => $id];

    if ($father_photo) {
        $fatherFilename = time() . '_' . $father_photo['name'];
        move_uploaded_file($father_photo['tmp_name'], "uploads/$fatherFilename");
        $fieldsToUpdate[] = 'father_photo = :father_photo';
        $params[':father_photo'] = $fatherFilename;
    }

    if ($mother_photo) {
        $motherFilename = time() . '_' . $mother_photo['name'];
        move_uploaded_file($mother_photo['tmp_name'], "uploads/$motherFilename");
        $fieldsToUpdate[] = 'mother_photo = :mother_photo';
        $params[':mother_photo'] = $motherFilename;
    }

    $query = "UPDATE family SET " . implode(', ', $fieldsToUpdate) . " WHERE id = :id";
    $stmt = $conn->prepare($query);
    $stmt->execute($params);

    echo json_encode(['status' => 'success']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}